<?php
session_start();

if (!isset($_SESSION['admin_logged_in'])) {
    header('Location: admin_login.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Tambah Kandidat</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>

<body class="bg-gray-100 flex items-center justify-center min-h-screen">
    <div class="bg-white p-8 rounded-lg shadow-md w-full max-w-lg">
        <h1 class="text-2xl font-bold mb-6 text-center">Tambah Kandidat Baru</h1>
        <form action="../src/add_kandidat.php" method="POST" enctype="multipart/form-data">
            <div class="mb-4">
                <label for="nama" class="block text-gray-700 font-bold mb-2">Nama Kandidat</label>
                <input type="text" id="nama" name="nama" class="w-full px-3 py-2 border rounded-md focus:outline-none focus:ring focus:border-blue-300" required>
            </div>

            <div class="mb-4">
                <label for="visi" class="block text-gray-700 font-bold mb-2">Visi</label>
                <textarea id="visi" name="visi" rows="2" class="w-full px-3 py-2 border rounded-md focus:outline-none focus:ring focus:border-blue-300" required></textarea>
            </div>

            <div class="mb-4">
                <label for="misi" class="block text-gray-700 font-bold mb-2">Misi (Satu per baris)</label>
                <textarea id="misi" name="misi" rows="6" class="w-full px-3 py-2 border rounded-md focus:outline-none focus:ring focus:border-blue-300" required></textarea>
            </div>

            <div class="mb-6">
                <label for="foto" class="block text-gray-700 font-bold mb-2">Foto Kandidat</label>
                <input type="file" id="foto" name="foto" class="w-full" accept="image/*" required>
                <p class="text-gray-500 text-sm mt-1">Hanya file gambar (JPG, JPEG, PNG) yang diperbolehkan.</p>
            </div>

            <button type="submit" class="w-full bg-green-500 text-white py-2 rounded-md hover:bg-green-600 transition-colors duration-300">Tambah Kandidat</button>
        </form>
        <div class="mt-4 text-center">
            <a href="admin_view.php" class="text-blue-500 hover:underline">Kembali ke Halaman Admin</a>
        </div>
    </div>
</body>

</html>