<?php
session_start();

if (!isset($_SESSION['admin_logged_in'])) {
    header('Location: admin_login.php');
    exit;
}

$pemilih_data = json_decode(file_get_contents('../data/pemilih.json'), true);

// Tambahkan variabel untuk nama sekolah dan path logo
$nama_sekolah = "SMK AL-IKHLAS TAROKAN"; // Ganti dengan nama sekolahmu
$logo_sekolah = "../public/assets/images/logo_sekolah.png"; // Ganti dengan path logo sekolah
$logo_osis = "../public/assets/images/logo_osis.png";     // Ganti dengan path logo osis
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cetak Kartu Pemilih</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        /* Sembunyikan tombol saat mencetak */
        @media print {
            .no-print {
                display: none;
            }
        }
    </style>
</head>

<body class="bg-gray-100 p-8">
    <div class="container mx-auto">
        <div class="no-print flex justify-between items-center mb-6">
            <h1 class="text-3xl font-bold">Cetak Kartu Pemilih</h1>
            <button onclick="window.print()" class="bg-blue-500 text-white px-4 py-2 rounded hover:bg-blue-600 transition-colors duration-300">
                Cetak Halaman
            </button>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 print-container">
            <?php foreach ($pemilih_data as $pemilih): ?>
                <div class="bg-white rounded-lg shadow-md p-6 border-2 border-gray-300">
                    <div class="flex justify-center items-center mb-4">
                        <img src="<?php echo htmlspecialchars($logo_sekolah); ?>" alt="Logo Sekolah" class="h-16 mr-4">
                        <div class="text-center">
                            <h2 class="text-xl font-bold"><?php echo htmlspecialchars($nama_sekolah); ?></h2>
                            <p class="text-sm text-gray-500">Kartu Pemilihan OSIS 2025-2026</p>
                        </div>
                        <img src="<?php echo htmlspecialchars($logo_osis); ?>" alt="Logo OSIS" class="h-16 ml-4">
                    </div>
                    <div class="text-lg">
                        <p><strong>Nama:</strong> <?php echo htmlspecialchars($pemilih['nama']); ?></p>
                        <p><strong>Kelas:</strong> <?php echo htmlspecialchars($pemilih['kelas']); ?></p>
                        <p><strong>No. Pemilih:</strong> <?php echo htmlspecialchars($pemilih['no_pilih']); ?></p>
                        <p><strong>Password:</strong> <?php echo htmlspecialchars($pemilih['password']); ?></p>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>

        <div class="mt-6 text-center no-print">
            <a href="admin_manage_pemilih.php" class="text-blue-500 hover:underline">Kembali ke Manajemen Pemilih</a>
        </div>
    </div>
</body>

</html>