<?php
session_start();

if (!isset($_SESSION['admin_logged_in'])) {
    header('Location: admin_login.php');
    exit;
}

// Sertakan pustaka FPDF
require('../src/fpdf/fpdf.php');

// Ambil data pemilih
$pemilih_data = json_decode(file_get_contents('../data/pemilih.json'), true);

// Tambahkan variabel untuk nama sekolah dan path logo
$nama_sekolah = "SMK AL-IKHLAS"; // Ganti dengan nama sekolahmu
$logo_sekolah = "../public/assets/images/logo_sekolah.png"; // Ganti dengan path logo sekolah
$logo_osis = "../public/assets/images/logo_osis.png";      // Ganti dengan path logo osis

// Inisialisasi PDF
$pdf = new FPDF('P', 'mm', 'A4');
$pdf->SetMargins(10, 10, 10);
$pdf->SetAutoPageBreak(true, 10);
$pdf->AddPage();

// Atur font
$pdf->SetFont('Arial', '', 10);

$x = 10;
$y = 10;
// Mengatur dimensi kartu untuk 3 kolom x 5 baris
$kartu_width = 60;
$kartu_height = 51;
$margin_hor = 5;
$margin_ver = 5;
$counter = 0;

foreach ($pemilih_data as $pemilih) {
    // Pindah ke baris baru jika sudah 3 kartu per baris
    if ($counter > 0 && $counter % 3 == 0) {
        $y += $kartu_height + $margin_ver;
        $x = 10;
    }

    // Tambah halaman jika sudah 15 kartu per halaman
    if ($counter > 0 && $counter % 15 == 0) {
        $pdf->AddPage();
        $y = 10;
        $x = 10;
    }

    // Gambar kartu
    $pdf->Rect($x, $y, $kartu_width, $kartu_height);

    // Tambahkan Logo Sekolah dan OSIS
    $pdf->Image($logo_sekolah, $x + 3, $y + 3, 10);
    $pdf->Image($logo_osis, $x + $kartu_width - 13, $y + 3, 9);

    // Teks di tengah
    $pdf->SetFont('Arial', 'B', 9);
    $pdf->SetXY($x, $y + 5);
    $pdf->Cell($kartu_width, 5, $nama_sekolah, 0, 1, 'C');

    $pdf->SetFont('Arial', '', 6);
    $pdf->SetXY($x, $y + 9);
    $pdf->Cell($kartu_width, 5, 'Kartu Pemilihan OSIS 2025-2026', 0, 1, 'C');

    // Informasi Pemilih
    $pdf->SetFont('Arial', '', 7);
    $pdf->SetXY($x + 3, $y + 20);
    $pdf->Cell(0, 5, 'Nama: ' . $pemilih['nama']);

    $pdf->SetXY($x + 3, $y + 25);
    $pdf->Cell(0, 5, 'Kelas: ' . $pemilih['kelas']);

    $pdf->SetXY($x + 3, $y + 30);
    $pdf->Cell(0, 5, 'No. Pemilih: ' . $pemilih['no_pilih']);

    $pdf->SetXY($x + 3, $y + 35);
    $pdf->Cell(0, 5, 'Password: ' . $pemilih['password']);

    // Pindah posisi X untuk kartu berikutnya
    $x += $kartu_width + $margin_hor;
    $counter++;
}

// Output PDF ke browser
$pdf->Output('I', 'kartu_pemilih.pdf');
