<?php
session_start();

if (!isset($_SESSION['admin_logged_in'])) {
    header('Location: admin_login.php');
    exit;
}

$id_to_edit = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$kandidat_data = json_decode(file_get_contents('../data/kandidat.json'), true);
$kandidat_to_edit = null;

foreach ($kandidat_data as $kandidat) {
    if ($kandidat['id'] == $id_to_edit) {
        $kandidat_to_edit = $kandidat;
        break;
    }
}

if (!$kandidat_to_edit) {
    echo "Data kandidat tidak ditemukan.";
    exit;
}

// Ubah array misi menjadi string dengan baris baru untuk ditampilkan di textarea
$misi_string = implode("\n", $kandidat_to_edit['misi']);
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Kandidat</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>

<body class="bg-gray-100 flex items-center justify-center min-h-screen">
    <div class="bg-white p-8 rounded-lg shadow-md w-full max-w-lg">
        <h1 class="text-2xl font-bold mb-6 text-center">Edit Data Kandidat</h1>
        <form action="../src/update_kandidat.php" method="POST" enctype="multipart/form-data">
            <input type="hidden" name="id" value="<?php echo htmlspecialchars($kandidat_to_edit['id']); ?>">

            <div class="mb-4">
                <label for="nama" class="block text-gray-700 font-bold mb-2">Nama Kandidat</label>
                <input type="text" id="nama" name="nama" value="<?php echo htmlspecialchars($kandidat_to_edit['nama']); ?>" class="w-full px-3 py-2 border rounded-md focus:outline-none focus:ring focus:border-blue-300" required>
            </div>

            <div class="mb-4">
                <label for="visi" class="block text-gray-700 font-bold mb-2">Visi</label>
                <textarea id="visi" name="visi" rows="2" class="w-full px-3 py-2 border rounded-md focus:outline-none focus:ring focus:border-blue-300" required><?php echo htmlspecialchars($kandidat_to_edit['visi']); ?></textarea>
            </div>

            <div class="mb-4">
                <label for="misi" class="block text-gray-700 font-bold mb-2">Misi (Satu per baris)</label>
                <textarea id="misi" name="misi" rows="6" class="w-full px-3 py-2 border rounded-md focus:outline-none focus:ring focus:border-blue-300" required><?php echo htmlspecialchars($misi_string); ?></textarea>
            </div>

            <div class="mb-6">
                <label for="foto" class="block text-gray-700 font-bold mb-2">Foto Kandidat (Kosongkan jika tidak diubah)</label>
                <input type="file" id="foto" name="foto" class="w-full" accept="image/*">
                <p class="text-gray-500 text-sm mt-1">File saat ini: **<?php echo htmlspecialchars($kandidat_to_edit['foto']); ?>**</p>
            </div>
            <button type="submit" class="w-full bg-green-500 text-white py-2 rounded-md hover:bg-green-600 transition-colors duration-300">Simpan Perubahan</button>
        </form>
        <div class="mt-4 text-center">
            <a href="admin_manage_kandidat.php" class="text-blue-500 hover:underline">Kembali ke Daftar Kandidat</a>
        </div>
    </div>
</body>

</html>