<?php
session_start();

if (!isset($_SESSION['admin_logged_in'])) {
    header('Location: admin_login.php');
    exit;
}

$no_pilih_to_edit = isset($_GET['no_pilih']) ? $_GET['no_pilih'] : '';
$pemilih_data = json_decode(file_get_contents('../data/pemilih.json'), true);
$pemilih_to_edit = null;

foreach ($pemilih_data as $pemilih) {
    if ($pemilih['no_pilih'] === $no_pilih_to_edit) {
        $pemilih_to_edit = $pemilih;
        break;
    }
}

if (!$pemilih_to_edit) {
    echo "Data pemilih tidak ditemukan.";
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Pemilih</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>

<body class="bg-gray-100 flex items-center justify-center min-h-screen">
    <div class="bg-white p-8 rounded-lg shadow-md w-full max-w-lg">
        <h1 class="text-2xl font-bold mb-6 text-center">Edit Data Pemilih</h1>
        <form action="../src/update_pemilih.php" method="POST">
            <input type="hidden" name="no_pilih_lama" value="<?php echo htmlspecialchars($pemilih_to_edit['no_pilih']); ?>">

            <div class="mb-4">
                <label for="no_pilih" class="block text-gray-700 font-bold mb-2">No. Pemilih</label>
                <input type="text" id="no_pilih" name="no_pilih" value="<?php echo htmlspecialchars($pemilih_to_edit['no_pilih']); ?>" class="w-full px-3 py-2 border rounded-md focus:outline-none focus:ring focus:border-blue-300" required>
            </div>
            <div class="mb-4">
                <label for="nama" class="block text-gray-700 font-bold mb-2">Nama</label>
                <input type="text" id="nama" name="nama" value="<?php echo htmlspecialchars($pemilih_to_edit['nama']); ?>" class="w-full px-3 py-2 border rounded-md focus:outline-none focus:ring focus:border-blue-300" required>
            </div>
            <div class="mb-4">
                <label for="kelas" class="block text-gray-700 font-bold mb-2">Kelas</label>
                <input type="text" id="kelas" name="kelas" value="<?php echo htmlspecialchars($pemilih_to_edit['kelas']); ?>" class="w-full px-3 py-2 border rounded-md focus:outline-none focus:ring focus:border-blue-300" required>
            </div>
            <div class="mb-6">
                <label for="password" class="block text-gray-700 font-bold mb-2">Password (Kosongkan jika tidak diubah)</label>
                <input type="password" id="password" name="password" class="w-full px-3 py-2 border rounded-md focus:outline-none focus:ring focus:border-blue-300">
            </div>
            <div class="mb-6 flex items-center">
                <input type="checkbox" id="sudah_memilih" name="sudah_memilih" <?php echo $pemilih_to_edit['sudah_memilih'] ? 'checked' : ''; ?> class="h-4 w-4 text-blue-600 border-gray-300 rounded focus:ring-blue-500">
                <label for="sudah_memilih" class="ml-2 block text-sm text-gray-900">Sudah Memilih</label>
            </div>
            <button type="submit" class="w-full bg-green-500 text-white py-2 rounded-md hover:bg-green-600 transition-colors duration-300">Simpan Perubahan</button>
        </form>
        <div class="mt-4 text-center">
            <a href="admin_manage_pemilih.php" class="text-blue-500 hover:underline">Kembali ke Daftar Pemilih</a>
        </div>
    </div>
</body>

</html>