<?php
session_start();

if (!isset($_SESSION['admin_logged_in'])) {
    header('Location: admin_login.php');
    exit;
}

$kandidat_data = json_decode(file_get_contents('../data/kandidat.json'), true);
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manajemen Kandidat</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        /* Gaya tambahan untuk icon */
        .icon {
            width: 1.25rem;
            height: 1.25rem;
            display: inline-block;
            vertical-align: middle;
            fill: currentColor;
        }
    </style>
</head>

<body class="bg-gray-100 p-4 sm:p-8">
    <div class="container mx-auto max-w-5xl">
        <header class="flex flex-col sm:flex-row justify-between items-center mb-6">
            <h1 class="text-2xl sm:text-3xl font-bold text-gray-800 mb-4 sm:mb-0">Manajemen Data Kandidat</h1>
            <a href="admin_add_kandidat.php" class="flex items-center space-x-2 bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700 transition-colors duration-300">
                <svg class="icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                    <path fill-rule="evenodd" d="M10 5a1 1 0 011 1v3h3a1 1 0 110 2h-3v3a1 1 0 11-2 0v-3H6a1 1 0 110-2h3V6a1 1 0 011-1z" clip-rule="evenodd" />
                </svg>
                <span>Tambah Kandidat</span>
            </a>
        </header>

        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <?php if (empty($kandidat_data)): ?>
                <div class="col-span-1 md:col-span-2 text-center p-8 text-gray-500 bg-white rounded-lg shadow-md">
                    <p>Tidak ada data kandidat. Silakan tambahkan kandidat baru.</p>
                </div>
            <?php else: ?>
                <?php foreach ($kandidat_data as $kandidat): ?>
                    <div class="bg-white p-6 rounded-lg shadow-md flex flex-col sm:flex-row items-center sm:items-start space-y-4 sm:space-y-0 sm:space-x-6">
                        <div class="flex-shrink-0">
                            <img src="../public/assets/images/<?php echo htmlspecialchars($kandidat['foto']); ?>" alt="Foto <?php echo htmlspecialchars($kandidat['nama']); ?>" class="h-24 w-24 object-cover rounded-full border-2 border-gray-200">
                        </div>

                        <div class="flex-grow text-center sm:text-left">
                            <span class="inline-block text-xs font-bold px-2 py-1 bg-gray-200 text-gray-700 rounded-full mb-2">ID #<?php echo htmlspecialchars($kandidat['id']); ?></span>
                            <h2 class="text-xl font-bold text-gray-900"><?php echo htmlspecialchars($kandidat['nama']); ?></h2>

                            <div class="mt-4">
                                <h3 class="font-semibold text-gray-800">Visi:</h3>
                                <p class="text-sm text-gray-600 mt-1"><?php echo htmlspecialchars($kandidat['visi']); ?></p>
                            </div>

                            <div class="mt-4">
                                <h3 class="font-semibold text-gray-800">Misi:</h3>
                                <ul class="list-disc list-inside text-sm text-gray-600 mt-1 space-y-1">
                                    <?php foreach ($kandidat['misi'] as $misi): ?>
                                        <li><?php echo htmlspecialchars($misi); ?></li>
                                    <?php endforeach; ?>
                                </ul>
                            </div>

                            <div class="mt-6 flex flex-wrap justify-center sm:justify-start space-x-2">
                                <a href="admin_edit_kandidat.php?id=<?php echo urlencode($kandidat['id']); ?>" class="flex items-center space-x-1 text-indigo-600 hover:text-indigo-800 transition-colors duration-200">
                                    <svg class="icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                                        <path d="M13.586 3.586a2 2 0 112.828 2.828l-.793.793-2.828-2.828.793-.793zM11.379 5.793L3 14.172V17h2.828l8.38-8.379-2.83-2.828z" />
                                    </svg>
                                    <span>Edit</span>
                                </a>
                                <a href="../src/delete_kandidat.php?id=<?php echo urlencode($kandidat['id']); ?>" class="flex items-center space-x-1 text-red-600 hover:text-red-800 transition-colors duration-200" onclick="return confirm('Apakah Anda yakin ingin menghapus kandidat ini? Semua suara yang sudah masuk akan hilang!');">
                                    <svg class="icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                                        <path fill-rule="evenodd" d="M9 2a1 1 0 00-.894.553L7.382 4H4a1 1 0 000 2v10a2 2 0 002 2h8a2 2 0 002-2V6a1 1 0 100-2h-3.382l-.724-1.447A1 1 0 0011 2H9zM7 8a1 1 0 012 0v6a1 1 0 11-2 0V8zm5-1a1 1 0 00-1 1v6a1 1 0 102 0V8a1 1 0 00-1-1z" clip-rule="evenodd" />
                                    </svg>
                                    <span>Hapus</span>
                                </a>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>

        <div class="mt-8 text-center">
            <a href="admin_view.php" class="inline-flex items-center space-x-2 text-blue-600 hover:underline">
                <svg class="icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                    <path fill-rule="evenodd" d="M9.707 16.707a1 1 0 01-1.414 0l-6-6a1 1 0 010-1.414l6-6a1 1 0 011.414 1.414L5.414 9H17a1 1 0 110 2H5.414l4.293 4.293a1 1 0 010 1.414z" clip-rule="evenodd" />
                </svg>
                <span>Kembali ke Halaman Admin</span>
            </a>
        </div>
    </div>
</body>

</html>