<?php
session_start();

if (!isset($_SESSION['admin_logged_in'])) {
    header('Location: admin_login.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Upload Data Pemilih</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>

<body class="bg-gray-100 flex items-center justify-center min-h-screen">
    <div class="bg-white p-8 rounded-lg shadow-md w-full max-w-lg">
        <h1 class="text-2xl font-bold mb-6 text-center">Upload Data Pemilih (CSV)</h1>

        <div class="mb-4">
            <p class="text-gray-700 mb-2">Unduh template untuk format file:</p>
            <a href="../src/download_template.php" class="bg-green-500 text-white px-4 py-2 rounded-md hover:bg-green-600 transition-colors duration-300">
                Download Template CSV
            </a>
        </div>

        <hr class="my-6">

        <form action="../src/upload_pemilih.php" method="POST" enctype="multipart/form-data">
            <div class="mb-6">
                <label for="file_pemilih" class="block text-gray-700 font-bold mb-2">Pilih File CSV</label>
                <input type="file" id="file_pemilih" name="file_pemilih" accept=".csv" class="w-full" required>
                <p class="text-gray-500 text-sm mt-1">Pastikan format file sesuai dengan template.</p>
            </div>
            <button type="submit" class="w-full bg-blue-500 text-white py-2 rounded-md hover:bg-blue-600 transition-colors duration-300">Upload Data</button>
        </form>

        <div class="mt-4 text-center">
            <a href="admin_view.php" class="text-blue-500 hover:underline">Kembali ke Halaman Admin</a>
        </div>
    </div>
</body>

</html>