<?php
session_start();

// Periksa apakah admin sudah login
if (!isset($_SESSION['admin_logged_in'])) {
    header('Location: admin_login.php');
    exit;
}

include '../src/admin.php'; // Kode ini akan mengambil data hasil

// Ambil data pemilih untuk statistik
$pemilih_data = json_decode(file_get_contents('../data/pemilih.json'), true);
$total_pemilih = count($pemilih_data);
$total_suara = array_sum(array_column($data_gabungan, 'suara'));
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard Admin - Hasil Pemilihan</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        /* Gaya tambahan untuk icon */
        .icon {
            width: 1rem;
            height: 1rem;
            display: inline-block;
            vertical-align: text-bottom;
            fill: currentColor;
        }
    </style>
</head>

<body class="bg-gray-100 p-4 sm:p-8">
    <div class="container mx-auto">
        <header class="flex flex-col sm:flex-row justify-between items-center mb-6">
            <h1 class="text-2xl sm:text-3xl font-bold text-gray-800 mb-4 sm:mb-0">Dashboard Admin</h1>
            <a href="../src/admin_logout.php" class="flex items-center space-x-2 bg-red-600 text-white px-4 py-2 rounded-lg hover:bg-red-700 transition-colors duration-300">
                <svg class="icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                    <path fill-rule="evenodd" d="M3 3a1 1 0 011-1h12a1 1 0 011 1v3a1 1 0 01-2 0V4H5v2a1 1 0 11-2 0V3zm2 5a1 1 0 011 1v7a1 1 0 01-1 1H4a1 1 0 01-1-1v-7a1 1 0 011-1h1zm7 0a1 1 0 011 1v7a1 1 0 01-1 1H7a1 1 0 01-1-1v-7a1 1 0 011-1h5zm7 0a1 1 0 011 1v7a1 1 0 01-1 1h-1a1 1 0 01-1-1v-7a1 1 0 011-1h1z" clip-rule="evenodd" />
                </svg>
                <span>Logout</span>
            </a>
        </header>

        <div class="bg-white p-6 rounded-lg shadow-xl">
            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-4 mb-6 text-center">
                <div class="bg-blue-100 p-4 rounded-lg shadow">
                    <h3 class="text-xl font-semibold text-blue-800">Total Pemilih</h3>
                    <p class="text-3xl text-blue-600 font-bold"><?php echo $total_pemilih; ?></p>
                </div>
                <div class="bg-green-100 p-4 rounded-lg shadow">
                    <h3 class="text-xl font-semibold text-green-800">Total Suara</h3>
                    <p class="text-3xl text-green-600 font-bold"><?php echo $total_suara; ?></p>
                </div>
                <div class="bg-yellow-100 p-4 rounded-lg shadow">
                    <h3 class="text-xl font-semibold text-yellow-800">Partisipasi</h3>
                    <?php
                    $partisipasi = ($total_pemilih > 0) ? round(($total_suara / $total_pemilih) * 100, 2) : 0;
                    ?>
                    <p class="text-3xl text-yellow-600 font-bold"><?php echo $partisipasi; ?>%</p>
                </div>
            </div>

            <div class="mb-8">
                <h2 class="text-2xl font-bold mb-4">Hasil Pemilihan Ketua OSIS</h2>
                <div class="bg-gray-50 p-4 rounded-lg">
                    <div class="overflow-x-auto">
                        <table class="min-w-full divide-y divide-gray-200">
                            <thead class="bg-gray-100">
                                <tr>
                                    <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider rounded-tl-lg">Nama Kandidat</th>
                                    <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider rounded-tr-lg">Jumlah Suara</th>
                                </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-200">
                                <?php foreach ($data_gabungan as $kandidat): ?>
                                    <tr>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900"><?php echo htmlspecialchars($kandidat['nama']); ?></td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-700 font-semibold"><?php echo htmlspecialchars($kandidat['suara']); ?></td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 gap-4">
                <a href="admin_add_kandidat.php" class="flex items-center justify-center space-x-2 bg-blue-500 text-white px-4 py-3 rounded-lg hover:bg-blue-600 transition-colors duration-300">
                    <svg class="icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                        <path fill-rule="evenodd" d="M10 5a1 1 0 011 1v3h3a1 1 0 110 2h-3v3a1 1 0 11-2 0v-3H6a1 1 0 110-2h3V6a1 1 0 011-1z" clip-rule="evenodd" />
                    </svg>
                    <span>Tambah Kandidat</span>
                </a>
                <a href="admin_manage_kandidat.php" class="flex items-center justify-center space-x-2 bg-yellow-500 text-white px-4 py-3 rounded-lg hover:bg-yellow-600 transition-colors duration-300">
                    <svg class="icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                        <path d="M13.586 3.586a2 2 0 112.828 2.828l-.793.793-2.828-2.828.793-.793zM11.379 5.793L3 14.172V17h2.828l8.38-8.379-2.83-2.828z" />
                    </svg>
                    <span>Manajemen Kandidat</span>
                </a>
                <a href="admin_upload_pemilih.php" class="flex items-center justify-center space-x-2 bg-purple-500 text-white px-4 py-3 rounded-lg hover:bg-purple-600 transition-colors duration-300">
                    <svg class="icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                        <path fill-rule="evenodd" d="M.032 2a1 1 0 01.99-1h18a1 1 0 011 1v14a1 1 0 01-1 1h-18a1 1 0 01-1-1V2zm4.5 1h11a.5.5 0 01.5.5V5h-12V3.5a.5.5 0 01.5-.5zM3 7v8h14V7H3z" clip-rule="evenodd" />
                    </svg>
                    <span>Upload Pemilih</span>
                </a>
                <a href="admin_manage_pemilih.php" class="flex items-center justify-center space-x-2 bg-gray-500 text-white px-4 py-3 rounded-lg hover:bg-gray-600 transition-colors duration-300">
                    <svg class="icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                        <path fill-rule="evenodd" d="M10 9a3 3 0 100-6 3 3 0 000 6zm-7 9a7 7 0 1114 0H3z" clip-rule="evenodd" />
                    </svg>
                    <span>Manajemen Pemilih</span>
                </a>
                <a href="../src/reset_voting.php" class="flex items-center justify-center space-x-2 bg-red-500 text-white px-4 py-3 rounded-lg hover:bg-red-600 transition-colors duration-300" onclick="return confirm('PERINGATAN! Tindakan ini akan menghapus semua suara dan mereset status voting. Apakah Anda yakin?');">
                    <svg class="icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                        <path fill-rule="evenodd" d="M4 2a1 1 0 011 1v12h10V3a1 1 0 112 0v14a1 1 0 01-1 1H4a1 1 0 01-1-1V3a1 1 0 011-1zm6 8a1 1 0 110-2 1 1 0 010 2z" clip-rule="evenodd" />
                    </svg>
                    <span>Reset Voting</span>
                </a>
            </div>
        </div>
    </div>
</body>

</html>