<?php
header('Content-Type: application/json');

// Read candidate and result data
$kandidat_data = json_decode(file_get_contents('../data/kandidat.json'), true);
$hasil_data = json_decode(file_get_contents('../data/hasil.json'), true);
$pemilih_data = json_decode(file_get_contents('../data/pemilih.json'), true);

// Calculate total voters
$total_pemilih = count($pemilih_data);

// Calculate total votes with a safety check
$total_suara_mentah = array_sum($hasil_data);
$total_suara = min($total_suara_mentah, $total_pemilih);

// Find the leading candidate(s)
$pemenang = null;
$suara_tertinggi = 0;
$pemenang_list = []; // Tambahkan array untuk menyimpan semua kandidat dengan suara tertinggi
$is_imbang = false;

if (!empty($hasil_data)) {
    arsort($hasil_data);
    $suara_tertinggi = reset($hasil_data);

    // Check for a tie
    $suara_tertinggi_count = 0;
    foreach ($hasil_data as $suara) {
        if ($suara == $suara_tertinggi) {
            $suara_tertinggi_count++;
        }
    }

    // If more than one candidate has the highest score, it's a tie
    if ($suara_tertinggi_count > 1) {
        $is_imbang = true;
    }

    // Find the winner's name(s) or just the first one if not tied
    if ($is_imbang) {
        foreach ($hasil_data as $id => $suara) {
            if ($suara == $suara_tertinggi) {
                foreach ($kandidat_data as $kandidat) {
                    if ($kandidat['id'] == $id) {
                        $pemenang_list[] = htmlspecialchars($kandidat['nama']);
                        break;
                    }
                }
            }
        }
        $pemenang = implode(' & ', $pemenang_list);
    } else {
        $pemenang_id = key($hasil_data);
        foreach ($kandidat_data as $kandidat) {
            if ($kandidat['id'] == $pemenang_id) {
                $pemenang = htmlspecialchars($kandidat['nama']);
                break;
            }
        }
    }
}

// Prepare data for JSON output
$kandidat_results = [];
foreach ($kandidat_data as $kandidat) {
    $suara_kandidat = isset($hasil_data[$kandidat['id']]) ? $hasil_data[$kandidat['id']] : 0;
    $persentase = ($total_suara > 0) ? round(($suara_kandidat / $total_suara) * 100, 1) : 0;
    $kandidat_results[] = [
        'id' => $kandidat['id'],
        'suara' => $suara_kandidat,
        'persentase' => $persentase,
        'is_pemenang' => ($suara_kandidat == $suara_tertinggi)
    ];
}

// Return the data
echo json_encode([
    'total_suara' => $total_suara,
    'partisipasi' => ($total_pemilih > 0) ? round(($total_suara / $total_pemilih) * 100, 2) : 0,
    'pemenang' => $pemenang,
    'suara_tertinggi' => $suara_tertinggi,
    'kandidat_results' => $kandidat_results,
    'is_imbang' => $is_imbang // Tambahkan status imbang
]);
