<?php
// Read candidate and result data
$kandidat_data = json_decode(file_get_contents('../data/kandidat.json'), true);
$hasil_data = json_decode(file_get_contents('../data/hasil.json'), true);
$pemilih_data = json_decode(file_get_contents('../data/pemilih.json'), true);

// Calculate total voters
$total_pemilih = count($pemilih_data);
$jumlah_kandidat = count($kandidat_data);

// Calculate total votes with a safety check
$total_suara_mentah = array_sum($hasil_data);
// Pastikan total suara tidak melebihi total pemilih
$total_suara = min($total_suara_mentah, $total_pemilih);

// Find the leading candidate
$pemenang = null;
$suara_tertinggi = 0;
if (!empty($hasil_data)) {
    arsort($hasil_data);
    $pemenang_id = key($hasil_data);
    $suara_tertinggi = current($hasil_data);
    foreach ($kandidat_data as $kandidat) {
        if ($kandidat['id'] == $pemenang_id) {
            $pemenang = $kandidat;
            break;
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="refresh" content="5">
    <title>Hasil Pemilihan OSIS - SMK Al Ikhlas Tarokan Kediri</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        .progress-bar {
            transition: width 0.5s ease-in-out;
        }
    </style>
</head>

<body class="bg-gradient-to-br from-gray-200 to-gray-300 font-sans min-h-screen">
    <div class="container mx-auto p-4 sm:p-8">
        <header class="flex flex-col md:flex-row justify-between items-center bg-white rounded-xl shadow-lg p-4 mb-8">
            <div class="flex flex-col md:flex-row items-center space-x-0 md:space-x-4 mb-4 md:mb-0 text-center md:text-left">
                <img src="../public/assets/images/logo_sekolah.png" alt="Logo Sekolah" class="w-16 h-16 md:w-20 md:h-20 object-contain mb-2 md:mb-0">
                <div>
                    <h1 class="text-xl md:text-3xl font-extrabold text-gray-800">SMK Al Ikhlas Tarokan Kediri</h1>
                    <p class="text-sm md:text-lg text-gray-600">Pemilihan Ketua OSIS Periode 2024/2025</p>
                </div>
            </div>
            <a href="login.php" class="bg-blue-600 text-white py-2 px-6 rounded-lg hover:bg-blue-700 transition-colors duration-300 font-semibold shadow-md">
                Vote Sekarang
            </a>
        </header>

        <div class="grid grid-cols-1 sm:grid-cols-3 gap-4 mb-8 text-center">
            <div class="bg-white p-6 rounded-xl shadow-lg border-b-4 border-blue-500">
                <p class="text-sm text-gray-500 uppercase font-semibold">Total Pemilih</p>
                <p class="text-3xl font-extrabold text-blue-600 mt-2"><?php echo $total_pemilih; ?></p>
            </div>
            <div class="bg-white p-6 rounded-xl shadow-lg border-b-4 border-green-500">
                <p class="text-sm text-gray-500 uppercase font-semibold">Total Suara Terkumpul</p>
                <p class="text-3xl font-extrabold text-green-600 mt-2"><?php echo $total_suara; ?></p>
            </div>
            <div class="bg-white p-6 rounded-xl shadow-lg border-b-4 border-yellow-500">
                <p class="text-sm text-gray-500 uppercase font-semibold">Partisipasi</p>
                <?php
                $partisipasi = ($total_pemilih > 0) ? round(($total_suara / $total_pemilih) * 100, 2) : 0;
                ?>
                <p class="text-3xl font-extrabold text-yellow-600 mt-2"><?php echo $partisipasi; ?>%</p>
            </div>
        </div>

        <div class="bg-white rounded-xl shadow-lg p-6 mb-8 text-center border-l-4 border-yellow-500 animate-pulse-once">
            <?php if ($total_suara == 0): ?>
                <h2 class="text-xl md:text-2xl font-bold text-gray-700">Status Pemilihan</h2>
                <p class="text-2xl md:text-3xl font-extrabold text-gray-500 mt-2">Belum ada suara yang masuk</p>
            <?php elseif ($total_suara == $total_pemilih): ?>
                <h2 class="text-xl md:text-2xl font-bold text-green-700">Ketua OSIS Terpilih</h2>
                <p class="text-3xl md:text-4xl font-extrabold text-green-700 mt-2">
                    <?php echo htmlspecialchars($pemenang['nama']); ?>
                </p>
                <p class="text-sm md:text-md text-gray-600 mt-1">dengan total suara: <span class="font-bold"><?php echo $suara_tertinggi; ?></span></p>
            <?php else: ?>
                <h2 class="text-xl md:text-2xl font-bold text-gray-700">Pemimpin Sementara</h2>
                <p class="text-3xl md:text-4xl font-extrabold text-yellow-700 mt-2">
                    <?php echo htmlspecialchars($pemenang['nama']); ?>
                </p>
                <p class="text-sm md:text-md text-gray-600 mt-1">dengan total suara: <span class="font-bold"><?php echo $suara_tertinggi; ?></span></p>
            <?php endif; ?>
        </div>

        <?php
        // Menentukan kelas CSS berdasarkan jumlah kandidat
        $grid_class = 'grid-cols-1 md:grid-cols-2 lg:grid-cols-3 xl:grid-cols-3';
        $container_class = '';
        if ($jumlah_kandidat === 2) {
            $grid_class = 'grid-cols-1 md:grid-cols-2';
            $container_class = 'md:flex md:justify-center';
        }
        ?>
        <div class="grid <?php echo $grid_class; ?> gap-6 <?php echo $container_class; ?>">
            <?php foreach ($kandidat_data as $kandidat):
                $suara_kandidat = isset($hasil_data[$kandidat['id']]) ? $hasil_data[$kandidat['id']] : 0;
                $persentase = ($total_suara > 0) ? round(($suara_kandidat / $total_suara) * 100, 1) : 0;
            ?>
                <div class="bg-white rounded-xl shadow-lg p-6 flex flex-col items-center text-center transform transition-transform hover:scale-105 duration-300 
                <?php echo ($pemenang && $kandidat['id'] == $pemenang['id']) ? 'border-2 border-yellow-500 shadow-xl' : ''; ?>">

                    <div class="relative w-full">
                        <img src="../public/assets/images/<?php echo htmlspecialchars($kandidat['foto']); ?>" alt="Poster <?php echo htmlspecialchars($kandidat['nama']); ?>" class="w-full h-auto object-cover rounded-lg border-4 border-gray-200 mb-4">
                        <span class="absolute top-2 left-2 bg-blue-600 text-white text-lg font-extrabold w-10 h-10 rounded-full flex items-center justify-center border-2 border-white shadow-md">
                            <?php echo htmlspecialchars($kandidat['id']); ?>
                        </span>
                    </div>

                    <!-- <h2 class="text-xl md:text-2xl font-bold text-gray-800 mb-2 mt-4"><?php echo htmlspecialchars($kandidat['nama']); ?></h2> -->

                    <!-- <div class="w-full text-left mt-2">
                        <p class="text-sm font-semibold text-gray-700">Visi:</p>
                        <p class="text-xs text-gray-600 mt-1"><?php echo htmlspecialchars($kandidat['visi']); ?></p>

                        <p class="text-sm font-semibold text-gray-700 mt-3">Misi:</p>
                        <ul class="list-disc list-inside text-xs text-gray-600 space-y-1 mt-1">
                            <?php foreach ($kandidat['misi'] as $misi): ?>
                                <li><?php echo htmlspecialchars($misi); ?></li>
                            <?php endforeach; ?>
                        </ul>
                    </div> -->

                    <div class="w-full mt-6 text-center">
                        <div class="text-2xl font-extrabold text-green-600">
                            <?php echo $suara_kandidat; ?>
                        </div>
                        <p class="text-sm text-gray-500 mt-1">Suara (<?php echo $persentase; ?>%)</p>
                        <div class="w-full bg-gray-200 rounded-full h-2.5 mt-2">
                            <div class="progress-bar bg-green-500 h-2.5 rounded-full" style="width: <?php echo $persentase; ?>%;"></div>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>

        <div class="mt-8 text-center">
            <a href="admin_login.php" class="text-gray-500 hover:text-gray-700 hover:underline text-sm md:text-base">Halaman Admin</a>
        </div>
    </div>
</body>

</html>