<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login Pemilihan OSIS</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        .password-container {
            position: relative;
        }

        .password-toggle {
            position: absolute;
            right: 12px;
            top: 70%;
            transform: translateY(-50%);
            cursor: pointer;
            color: #9ca3af;
        }

        .password-toggle:hover {
            color: #1f2937;
        }
    </style>
</head>

<body class="bg-gray-100 flex items-center justify-center min-h-screen">
    <div class="bg-white p-8 rounded-lg shadow-md w-full max-w-sm">
        <h1 class="text-2xl font-bold mb-6 text-center">Login Pemilihan OSIS</h1>
        <form action="../src/login.php" method="POST">
            <div class="mb-4">
                <label for="no_pilih" class="block text-gray-700 font-bold mb-2">Nomor Pemilih</label>
                <input type="text" id="no_pilih" name="no_pilih" class="w-full px-3 py-2 border rounded-md focus:outline-none focus:ring focus:border-blue-300" required>
            </div>
            <div class="mb-6 password-container">
                <label for="password" class="block text-gray-700 font-bold mb-2">Password</label>
                <input type="password" id="password" name="password" class="w-full px-3 py-2 border rounded-md focus:outline-none focus:ring focus:border-blue-300" required>
                <span class="password-toggle" onclick="togglePasswordVisibility()">
                    <!-- SVG icon for eye -->
                    <svg id="eye-open" xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor">
                        <path d="M10 12.5a2.5 2.5 0 100-5 2.5 2.5 0 000 5z" />
                        <path fill-rule="evenodd" d="M.661 10.322A13.923 13.923 0 0110 3.5c3.23 0 6.273 1.258 8.529 3.522a.75.75 0 01-.019 1.056c-.27.24-.65.232-.913-.016a12.441 12.441 0 00-7.597-3.141 12.441 12.441 0 00-7.597 3.14a.75.75 0 01-.913.016.75.75 0 01-.019-1.056z" clip-rule="evenodd" />
                    </svg>
                    <!-- SVG icon for eye-slash -->
                    <svg id="eye-closed" xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 hidden" viewBox="0 0 20 20" fill="currentColor">
                        <path d="M12.44 14.56a.75.75 0 00-.23-.217 6.44 6.44 0 00-4.63-.949L4.444 6.944a.75.75 0 00-1.06 1.06L7.25 12a.75.75 0 00.75.75h4.25a.75.75 0 000-1.5H8.75a.75.75 0 000 1.5H12.44z" />
                        <path d="M10 1.5A8.5 8.5 0 001.661 10.322a.75.75 0 00.019 1.056c.27.24.65.232.913-.016a12.441 12.441 0 017.307-3.141 12.441 12.441 0 017.307 3.14a.75.75 0 00.913.016c.27-.24.278-.621.019-1.056A8.5 8.5 0 0010 1.5z" />
                    </svg>
                </span>
            </div>
            <button type="submit" class="w-full bg-blue-500 text-white py-2 rounded-md hover:bg-blue-600 transition-colors duration-300">Login</button>
        </form>
    </div>
    <script>
        function togglePasswordVisibility() {
            const passwordInput = document.getElementById('password');
            const eyeOpenIcon = document.getElementById('eye-open');
            const eyeClosedIcon = document.getElementById('eye-closed');

            if (passwordInput.type === 'password') {
                passwordInput.type = 'text';
                eyeOpenIcon.classList.add('hidden');
                eyeClosedIcon.classList.remove('hidden');
            } else {
                passwordInput.type = 'password';
                eyeOpenIcon.classList.remove('hidden');
                eyeClosedIcon.classList.add('hidden');
            }
        }
    </script>
</body>

</html>