<?php
// Tentukan pesan, judul, dan warna berdasarkan status
$message = 'Suara Anda telah berhasil direkam.';
$title = 'Terima kasih atas partisipasi Anda!';
$title_color = 'text-green-600';
$button_link = 'index.php';
$button_text = 'Kembali ke Halaman Utama';

if (isset($_GET['status']) && $_GET['status'] === 'already_voted') {
    $message = 'Anda sudah memberikan suara.';
    $title = 'Pemberitahuan';
    $title_color = 'text-red-600';
    $button_link = 'login.php';
    $button_text = 'Kembali ke Halaman Login';
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Notifikasi</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>

<body class="bg-gray-100 flex items-center justify-center min-h-screen">
    <div class="bg-white p-8 rounded-lg shadow-md w-full max-w-sm text-center">
        <h1 class="text-2xl font-bold mb-4 <?php echo htmlspecialchars($title_color); ?>"><?php echo htmlspecialchars($title); ?></h1>
        <p class="text-gray-700 mb-6"><?php echo htmlspecialchars($message); ?></p>
        <a href="<?php echo htmlspecialchars($button_link); ?>" class="bg-blue-500 text-white py-2 px-4 rounded-md hover:bg-blue-600 transition-colors duration-300"><?php echo htmlspecialchars($button_text); ?></a>
    </div>
</body>

</html>