<?php
session_start();
// Cek apakah session 'no_pilih' sudah ada, jika tidak, arahkan kembali ke halaman login.
if (!isset($_SESSION['no_pilih'])) {
    header('Location: login.php');
    exit;
}

// Ambil data pemilih dari file JSON
$pemilih_data = json_decode(file_get_contents('../data/pemilih.json'), true);
$nama_pemilih = 'Pemilih'; // Nilai default jika nama tidak ditemukan

// Cari nama pemilih berdasarkan no_pilih dari sesi
foreach ($pemilih_data as $pemilih) {
    if ($pemilih['no_pilih'] === $_SESSION['no_pilih']) {
        $nama_pemilih = $pemilih['nama'];
        break;
    }
}

$kandidat_data = json_decode(file_get_contents('../data/kandidat.json'), true);
$jumlah_kandidat = count($kandidat_data);
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pilih Ketua OSIS</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        .card-kandidat {
            transition: all 0.3s ease-in-out;
            cursor: pointer;
        }

        .card-kandidat:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
        }

        input[type="radio"]:checked+label {
            border-color: #3b82f6;
            box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.5);
        }

        .radio-label {
            transition: border-color 0.3s ease-in-out, box-shadow 0.3s ease-in-out;
            border-width: 3px;
        }
    </style>
</head>

<body class="bg-gray-100 min-h-screen flex flex-col items-center justify-center p-4">
    <div class="container mx-auto">
        <header class="text-center mb-8">
            <h1 class="text-3xl md:text-4xl font-extrabold text-gray-800">Selamat Datang, <br><span class="text-blue-600"><?php echo htmlspecialchars($nama_pemilih); ?></span>!</h1>
            <p class="text-lg md:text-xl text-gray-600 mt-2">Pilih Ketua OSIS Pilihanmu</p>
            <p class="text-sm text-gray-500 mt-1">Satu Suara Menentukan Masa Depan Sekolah.</p>
        </header>

        <?php
        // Menentukan kelas CSS berdasarkan jumlah kandidat
        $grid_class = 'grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6';
        $form_class = '';
        if ($jumlah_kandidat === 2) {
            // Untuk 2 kandidat, gunakan flexbox untuk memusatkan
            $form_class = 'flex flex-wrap justify-center md:flex-row';
            $grid_class = ''; // Kosongkan grid class jika menggunakan flexbox
        }
        ?>

        <form action="../src/vote.php" method="POST" class="<?php echo $form_class; ?> <?php echo $grid_class; ?>">
            <?php foreach ($kandidat_data as $kandidat): ?>
                <div class="card-kandidat bg-white rounded-xl shadow-lg p-6 flex flex-col items-center text-center 
                <?php echo ($jumlah_kandidat === 2) ? 'md:w-1/2 md:max-w-md mx-2' : ''; ?>">
                    <input type="radio" id="kandidat_<?php echo $kandidat['id']; ?>" name="kandidat_id" value="<?php echo $kandidat['id']; ?>" class="hidden" required>
                    <label for="kandidat_<?php echo $kandidat['id']; ?>" class="radio-label w-full flex flex-col items-center p-4 border-2 border-gray-200 rounded-lg cursor-pointer">
                        <div class="relative mb-4">
                            <img src="../public/assets/images/<?php echo htmlspecialchars($kandidat['foto']); ?>" alt="Foto <?php echo htmlspecialchars($kandidat['nama']); ?>" class="w-32 h-32 md:w-40 md:h-40 rounded-full object-cover border-4 border-white shadow-md">
                            <span class="absolute -top-3 -right-3 bg-blue-600 text-white text-lg font-bold w-10 h-10 rounded-full flex items-center justify-center border-4 border-white shadow-lg">
                                <?php echo htmlspecialchars($kandidat['id']); ?>
                            </span>
                        </div>
                        <h2 class="text-xl md:text-2xl font-bold text-gray-800 mb-2"><?php echo htmlspecialchars($kandidat['nama']); ?></h2>

                        <div class="mt-2 text-left w-full">
                            <p class="font-bold text-gray-800 text-sm">Visi:</p>
                            <p class="text-gray-600 text-sm mb-2 leading-relaxed"><?php echo htmlspecialchars($kandidat['visi']); ?></p>

                            <p class="font-bold text-gray-800 text-sm">Misi:</p>
                            <ul class="list-disc list-inside text-gray-600 text-sm space-y-1">
                                <?php foreach ($kandidat['misi'] as $misi): ?>
                                    <li><?php echo htmlspecialchars($misi); ?></li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    </label>
                </div>
            <?php endforeach; ?>

            <div class="col-span-full mt-6 text-center w-full">
                <button type="submit" class="w-full sm:w-auto bg-blue-600 text-white py-3 px-12 rounded-lg font-extrabold text-lg hover:bg-blue-700 transition-colors duration-300 shadow-xl">
                    Kirim Pilihan
                </button>
            </div>
        </form>
    </div>
</body>

</html>