<?php
session_start();

if (!isset($_SESSION['admin_logged_in'])) {
    header('Location: ../public/admin_login.php');
    exit;
}

if (isset($_GET['no_pilih'])) {
    $no_pilih_to_delete = $_GET['no_pilih'];
    $pemilih_data = json_decode(file_get_contents('../data/pemilih.json'), true);

    $found_key = null;
    foreach ($pemilih_data as $key => $pemilih) {
        if ($pemilih['no_pilih'] === $no_pilih_to_delete) {
            $found_key = $key;
            break;
        }
    }

    if ($found_key !== null) {
        unset($pemilih_data[$found_key]);
        file_put_contents('../data/pemilih.json', json_encode(array_values($pemilih_data), JSON_PRETTY_PRINT));
        header('Location: ../public/admin_manage_pemilih.php?status=success_delete');
        exit;
    } else {
        echo "Gagal menghapus data. Pemilih tidak ditemukan.";
    }
} else {
    header('Location: ../public/admin_manage_pemilih.php');
    exit;
}
