<?php
session_start();

// Periksa apakah admin sudah login
if (!isset($_SESSION['admin_logged_in'])) {
    header('Location: ../public/admin_login.php');
    exit;
}

// 1. Reset hasil voting menjadi 0 untuk setiap kandidat yang ada
$hasil_data = json_decode(file_get_contents('../data/hasil.json'), true);
foreach ($hasil_data as $id_kandidat => $jumlah_suara) {
    $hasil_data[$id_kandidat] = 0;
}
file_put_contents('../data/hasil.json', json_encode($hasil_data, JSON_PRETTY_PRINT));

// 2. Reset status semua pemilih menjadi 'false'
$pemilih_data = json_decode(file_get_contents('../data/pemilih.json'), true);
foreach ($pemilih_data as &$pemilih) {
    $pemilih['sudah_memilih'] = false;
}
file_put_contents('../data/pemilih.json', json_encode($pemilih_data, JSON_PRETTY_PRINT));

// Arahkan kembali ke halaman admin dengan pesan sukses
header('Location: ../public/admin_view.php?status=voting_reset_success');
exit;
