<?php
session_start();

if (!isset($_SESSION['admin_logged_in'])) {
    header('Location: ../public/admin_login.php');
    exit;
}

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['no_pilih_lama'])) {
    $no_pilih_lama = $_POST['no_pilih_lama'];
    $no_pilih_baru = $_POST['no_pilih'];
    $nama = $_POST['nama'];
    $kelas = $_POST['kelas'];
    $password_baru = $_POST['password'];
    $sudah_memilih = isset($_POST['sudah_memilih']);

    $pemilih_data = json_decode(file_get_contents('../data/pemilih.json'), true);

    $found_key = null;
    foreach ($pemilih_data as $key => $pemilih) {
        if ($pemilih['no_pilih'] === $no_pilih_lama) {
            $found_key = $key;
            break;
        }
    }

    if ($found_key !== null) {
        $pemilih_data[$found_key]['no_pilih'] = $no_pilih_baru;
        $pemilih_data[$found_key]['nama'] = $nama;
        $pemilih_data[$found_key]['kelas'] = $kelas;
        $pemilih_data[$found_key]['sudah_memilih'] = $sudah_memilih;

        if (!empty($password_baru)) {
            $pemilih_data[$found_key]['password'] = $password_baru;
        }

        file_put_contents('../data/pemilih.json', json_encode($pemilih_data, JSON_PRETTY_PRINT));
        header('Location: ../public/admin_manage_pemilih.php?status=success_update');
        exit;
    } else {
        echo "Gagal mengupdate data. Pemilih tidak ditemukan.";
    }
}
