<?php
session_start();

if (!isset($_SESSION['admin_logged_in'])) {
    header('Location: ../public/admin_login.php');
    exit;
}

if (isset($_FILES['file_pemilih']) && $_FILES['file_pemilih']['error'] == 0) {
    $file = $_FILES['file_pemilih']['tmp_name'];
    $file_handle = fopen($file, "r");

    // Baca data pemilih yang sudah ada
    $pemilih_data = json_decode(file_get_contents('../data/pemilih.json'), true);

    // Skip header
    fgetcsv($file_handle);

    // Proses baris per baris dari file CSV
    while (($data = fgetcsv($file_handle, 1000, ",")) !== FALSE) {
        // Pastikan baris memiliki 4 kolom: no_pilih, nama, kelas, password
        if (count($data) == 4) {
            list($no_pilih, $nama, $kelas, $password) = $data;

            // Cek duplikasi no_pilih sebelum menambahkan
            $is_duplicate = false;
            foreach ($pemilih_data as $p) {
                if ($p['no_pilih'] === $no_pilih) {
                    $is_duplicate = true;
                    break;
                }
            }

            if (!$is_duplicate) {
                $new_pemilih = [
                    "no_pilih" => $no_pilih,
                    "nama" => $nama,
                    "kelas" => $kelas,
                    "password" => $password,
                    "sudah_memilih" => false
                ];
                $pemilih_data[] = $new_pemilih;
            }
        }
    }

    fclose($file_handle);

    // Simpan kembali data ke file JSON
    file_put_contents('../data/pemilih.json', json_encode($pemilih_data, JSON_PRETTY_PRINT));

    header('Location: ../public/admin_view.php?status=success_upload');
    exit;
} else {
    echo "Terjadi kesalahan saat mengunggah file.";
}
