<?php
session_start();

if (!isset($_SESSION['no_pilih'])) {
    header('Location: ../public/index.php');
    exit;
}

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['kandidat_id'])) {
    $no_pilih = $_SESSION['no_pilih'];
    $kandidat_id = $_POST['kandidat_id'];

    // Update status pemilih
    $pemilih_data = json_decode(file_get_contents('../data/pemilih.json'), true);
    foreach ($pemilih_data as &$pemilih) {
        if ($pemilih['no_pilih'] == $no_pilih) {
            $pemilih['sudah_memilih'] = true;
            break;
        }
    }
    file_put_contents('../data/pemilih.json', json_encode($pemilih_data, JSON_PRETTY_PRINT));

    // Update hasil suara
    $hasil_data = json_decode(file_get_contents('../data/hasil.json'), true);
    if (isset($hasil_data[$kandidat_id])) {
        $hasil_data[$kandidat_id]++;
    }
    file_put_contents('../data/hasil.json', json_encode($hasil_data, JSON_PRETTY_PRINT));

    // Hapus session dan redirect ke halaman berhasil
    unset($_SESSION['no_pilih']);
    header('Location: ../public/sukses.php');
    exit;
}
